if (!window.services.infoService) throw "Settings.js > The infoService isn't loaded.";
var infoService = window.services.infoService;

if (!window.services.actionService) throw "Settings.js > The actionService isn't loaded.";
var actionService = window.services.actionService;

var timeSystemTimeSet = new Date();
var systemTime = new Date();

var tabbableInputs = document.getElementsByClassName("tabbable-input");

var current = -1;
function switchFocusInput(goToNext) {
    if (goToNext) {
        // wanneer het laatste input veld bereikt is willen we door naar de eerste;
        if (current + 1 === tabbableInputs.length) {
            current = 0;
        } else {
            current++;
        }
    } else {
        // wanneer het eerste input veld bereikt is willen we door naar de laatste;
        if (current - 1 < 0) {
            current = tabbableInputs.length - 1;
        } else {
            current--;
        }
    }
    tabbableInputs[current].focus();
}


document.onkeydown = function(event) {
    var remote = {
        KEY_FASTFORWARD : 417,
        KEY_FASTREVERSE: 412,
        KEY_OK: 13,
        KEY_BLUE : 406,
        KEY_YELLOW : 405
    }

    var keyboard = {
        KEY_LEFT: 37,
        KEY_RIGHT: 39,
        KEY_UP: 38,
        KEY_DOWN: 40,
        KEY_Q: 81,
        KEY_W: 87,
        KEY_PAGEUP: 33,
        KEY_PAGEDOWN: 34,
        KEY_ENTER: 13
    }

    if (event.keyCode === remote.KEY_FASTFORWARD || event.keyCode === keyboard.KEY_RIGHT || event.keyCode === keyboard.KEY_DOWN) {
        switchFocusInput(true);
    } else if (event.keyCode === remote.KEY_FASTREVERSE || event.keyCode === keyboard.KEY_LEFT || event.keyCode === keyboard.KEY_UP) {
        switchFocusInput(false);
    }

    if (event.keyCode === remote.KEY_BLUE) {
        document.getElementById('closeNoSave').focus();
    }

    if (event.keyCode === remote.KEY_YELLOW) {
        document.getElementById('closeAndSave').focus();
    }
};

var closeNoSave = function() {    
    document.getElementById('closeNoSave').blur();
    parent.postMessage('settingsPage_KeyPressed_close', '*');
};

var closeAndSave = function () {
    document.getElementById('closeAndSave').blur();

    var key = 'settings.apiBaseUrl';
    infoService.updateConfigSetting(key, document.getElementById('url').value)
        .then(function () {
            actionService.rebootApplication();
        })
        .catch(function (err) {
            parent.postMessage('settingsPage_KeyPressed_close', '*');
        });
};



var ViewModel = function() {
    var self = this;
    self.apiUrl = ko.observable("");
    self.apiAvailable = ko.observable(false);

    self.closeNoSave = closeNoSave;
    self.closeAndSave = closeAndSave;

    self.additionalInfo = ko.observable(null);
    self.systemTime = ko.observable("");
    self.formatMb = function(numberInBytes, unit) {
        var numberInMegaBytes = numberInBytes / 1024000;
        numberInMegaBytes = (numberInMegaBytes.toFixed(2) + '').replace('.', ',');
        return numberInMegaBytes + " " + unit;
    };

    infoService.getNapiUrl().then(function(apiUrl) {
        self.apiUrl(apiUrl);
        infoService.getApiAvailability(apiUrl).then(function(apiAvailable) {
            self.apiAvailable(apiAvailable);
        });
    });
    
    infoService.getAdditionalInfo().then(function(data) {
        systemTime = new Date(data.SystemTimes.local);
        self.additionalInfo(data);
    });
};
var vm = new ViewModel();

var setSystemTime = function()
{
    var now = new Date().getTime();
    var timeSinceLastSystemTimeSet = now - timeSystemTimeSet.getTime();
    var systemTimeMilliseconds = systemTime.getTime() + timeSinceLastSystemTimeSet;
    vm.systemTime(new Date(systemTimeMilliseconds).toString());      
}

setInterval(setSystemTime, 1000);

document.addEventListener("DOMContentLoaded", function() {
    ko.applyBindings(vm);
});