define(['jquery'], function(jQuery) {
	'use strict';	
	var $ = jQuery;

	var SimpleCarrousel =	
		function (settings) {
			this.init(settings);
	}

	SimpleCarrousel.prototype = {
		init: function (settings) 
			{				
				var settings = settings;
				var self = this;
				var $ = jQuery;
				
				var defaultSettings = {
					slides: [],
					shuffleSlides: false,
					imageSize: 'cover',
					slideDelay: 2000,
					effectTime: 500,
					autoStart: true,
					backgroundColor: '#000'
				};				
				settings = mergeOptions(defaultSettings, settings); 
				
				self.settings = settings;
				
				if (settings.shuffleSlides)
				{
					shuffle(settings.slides);
				}
				
				self.parent = $(settings.element);
										
				var slideCss = { 
					'position': 'absolute',
					'left': '0','top': '0',
					'right': '0','bottom': '0',	
					// 'background-color': settings.backgroundColor || '#000'
					};
					
				var slideImgCss = {
					'position': 'absolute',
					'left': '0','top': '0',
					'right': '0','bottom': '0',										
					'background-size': settings.imageSize || 'cover',
					'background-repeat': 'no-repeat',
					'background-position': settings.imagePosition || '50% 50%'
					};
				
				self.slideElements = [];
												
				
				self.slides = settings.slides;
				self.index = -1;
				self.timeout = null;				
				self.first = true;
				self.doFadeFirst = false;
				
				function createSlides()
				{
					self.allSlides = $();
				
					for(var i=0;i<self.slides.length;i+=1)
					{
						var $slideElement = $new('div', self.parent, null, ['slide']);
						$slideElement.css(slideCss);																	
						$slideElement.css('z-index', self.slides.length - i);
						
						var $content = $new('div', $slideElement, null, ['slideContent']);
						$content.css({ position: 'absolute', left:0, top:0, width:$slideElement.width() - 20, height:$slideElement.height() - 20, border: '10px solid yellow', borderRadius: '20px', overflow: 'hidden' });
							
						if (isString(self.slides[i]))
						{
							var $imageEl = $new('div', $content);

							$imageEl.css(slideImgCss);
							var imageSrc = "url('" + self.slides[i] + "')";
							$imageEl.css('background-image', imageSrc);							
						}
						else
						{
							$content.html( self.slides[i].html );
						}
						
						self.slideElements[i] = $slideElement;					
						self.allSlides.add($slideElement);
					}
				}
					
				createSlides();
				
				self.start = function () {
					self.slide();
				}
				
				self.getIndex = 
					function(index) {				
						if (index >= 0) return index % self.slides.length;
						if (index < 0) return (self.slides.length-1) - ((Math.abs(index)-1) % self.slides.length);
					};
				
				self.slide =
					function () {																								
						if (self.slides.length !== 0) 
						{							
							for(var i=0;i<self.slides.length;i+=1)
							{
								self.slideElements[i].css( { zIndex: 0, display: 'none' }); 									
							}
													
							var $currentSlide = null;
							var $nextSlide =  null;
							
							if (self.first)
							{
								self.first = false;
								$nextSlide = self.slideElements[self.getIndex(self.index)];
							} 
							else
							{
								$currentSlide = self.slideElements[self.getIndex(self.index)];
								$currentSlide.css({ zIndex: 1, display: 'block' });								
								self.index = self.getIndex(self.index+1);
								
								$nextSlide = self.slideElements[self.getIndex(self.index)];								
							}														
							$nextSlide.css({ zIndex: 2, display: 'block' });
							
							settings.slideTransition(settings, $currentSlide, $nextSlide);																									

							// Set timeout for next slide
							if (!self.onlyFirst) {
								self.timeout = setTimeout(function () {
									self.slide();
								}, settings.slideDelay + settings.effectTime);
							}
						} else {
							if (self.first) {
								self.doFadeFirst = true;
							}
							self.timeout = setTimeout(function () {
								self.slide();
							}, 50);
						}
				}

				setTimeout(function () {
					self.start()
				}, 160); // start after N ms (time to load first image from
							// cache)
			}
			
		}
	return SimpleCarrousel;
});