define([ 'jquery', 'tools/tools', 'tools/validate' ], function() {
	'use strict';
	// var $ = require('jquery');
	var tools = require('tools/tools');
	var validate = require('tools/validate');

	var log = tools.log;
	// var format = tools.format;

	var getStr = validate.getStr;
	var getNum = validate.getNum;
	// var isNumber = validate.isNumber;
	var getColor = validate.getColor;
	var del = tools.del;

	// =======
	// Border
	function TncBorder(settings) {
		this.init(settings);
	}

	TncBorder.prototype.init = function(settings) {
		var self = this;
		self.settings = settings || {};

		self.color = getColor(self.settings.color, 'transparent');
		self.radius = getNum(self.settings.radius, 0);
		self.size = getNum(self.settings.size, 0);
		self.style = getStr(self.settings.style, 'solid');
	};

	TncBorder.prototype.applyBorder = function($e) {
		var self = this;
		$e.css({
			borderColor : self.color,
			borderRadius : self.radius + 'px',
			borderWidth : self.size + 'px',
			borderStyle : self.style
		});
	};

	TncBorder.prototype.getSettings = function() {
		var self = this;

		return {
			color : self.settings.color,
			radius : self.settings.radius,
			size : self.settings.size,
			style : self.settings.style
		};
	};

	TncBorder.prototype.unload = function() {
		var self = this;
		del(self, 'settings');

		self.unloaded = true;

		log('Border unloaded', self);

		self = null;
	};

	return TncBorder;
});
