define([ 'jquery', 'tools/tools', 'tools/validate' ], function() {
	'use strict';
	// var $ = require('jquery');
	var tools = require('tools/tools');
	var validate = require('tools/validate');

	var log = tools.log;
	// var format = tools.format;

	// var getStr = validate.getStr;
	// var getColor = validate.getColor;
	var getNum = validate.getNum;
	var del = tools.del;

	// =======
	// Margin
	function TncMargin(settings) {
		this.init(settings);
	}

	TncMargin.prototype.init = function(settings) {
		var self = this;
		self.settings = settings || {};

		self.top = getNum(self.settings.top, 0);
		self.right = getNum(self.settings.right, 0);
		self.bottom = getNum(self.settings.bottom, 0);
		self.left = getNum(self.settings.left, 0);
	};

	TncMargin.prototype.getSettings = function() {
		var self = this;

		return {
			top : self.top,
			right : self.right,
			bottom : self.bottom,
			left : self.left
		};
	};

	TncMargin.prototype.applyMargin = function($e) {
		var self = this;
		$e.css({
			top : self.top + '%',
			right : self.right + '%',
			bottom : self.bottom + '%',
			left : self.left + '%'
		});
	};

	TncMargin.prototype.unload = function() {
		var self = this;
		del(self, 'settings');

		self.unloaded = true;

		log('Margin unloaded', self);

		self = null;
	};

	return TncMargin;
});
