define([ 'jquery', 'tools/tools', 'tools/validate', 'tools/numbers' ], function(jQuery) {
	'use strict';
	// var $ = require('jquery');
	var tools = require('tools/tools');
	var numbers = require('tools/numbers');
	var validate = require('tools/validate');

	var log = tools.log;
	// var format = tools.format;

	// var getStr = validate.getStr;
	// var getColor = validate.getColor;
	var getNum = validate.getNum;
	var round100 = numbers.round100;
	var limit100 = numbers.limit100;
	// var del = tools.del;

	// =======
	// Position
	function TncPosition(settings) {
		this.init(settings);
	}

	TncPosition.prototype.init = function(settings) {
		var self = this;
		self.settings = settings || {};

		self.position = getNum(self.settings.position, 1);
		self.xPos = getNum(self.settings.xPos, 0);
		self.yPos = getNum(self.settings.yPos, 0);
		self.height = getNum(self.settings.height, 0);
		self.width = getNum(self.settings.width, 0);
		self.zIndex = getNum(self.settings.zIndex, 0);
	};

	TncPosition.prototype.load = function() {
		var self = this;

		// setup position and size limitations (?)
		self.width = round100(limit100(self.width));
		self.height = round100(limit100(self.height));

		self.xPos = round100(limit100(self.xPos + self.width) - self.width);
		self.yPos = round100(limit100(self.yPos + self.height) - self.height);

		self.xPos = round100(limit100(self.xPos));
		self.yPos = round100(limit100(self.yPos));

		switch (self.position) {
		case 2: // topleft
			self.left = 100 - (self.xPos + self.width);
			self.top = self.yPos;
			break;
		case 3: // bottomleft
			self.left = self.xPos;
			self.top = 100 - (self.yPos + self.height);
			break;
		case 4: // bottomright
			self.left = 100 - (self.xPos + self.width);
			self.top = 100 - (self.yPos + self.height);
			break;
		case 1: // topright
		default:
			self.left = self.xPos;
			self.top = self.yPos;
		}
	};

	TncPosition.prototype.unload = function() {
		var self = this;

		delete self.settings;

		self.unloaded = true;

		log('Position unloaded', self);
		self = null;
	};

	TncPosition.prototype.getSettings = function() {
		var self = this;

		return {
			position : self.position,
			xPos : self.xPos,
			yPos : self.yPos,
			height : self.height,
			width : self.width,
			zIndex : self.zIndex
		};
	};

	TncPosition.prototype.fromTopLeft = function(percentageLeft, percentageTop, percentageWidth, percentageHeight) {
		var self = this;
		self.width = percentageWidth;
		self.height = percentageHeight;

		var percentageRight = 100 - (percentageLeft + percentageWidth);
		var percentageBottom = 100 - (percentageTop + percentageHeight);

		switch (self.position) {
		case 2:
			self.xPos = percentageRight;
			self.yPos = percentageTop;
			break;
		case 3:
			self.xPos = percentageLeft;
			self.yPos = percentageBottom;
			break;
		case 4:
			self.xPos = percentageRight;
			self.yPos = percentageBottom;
			break;
		case 1:
		default:
			self.xPos = percentageLeft;
			self.yPos = percentageTop;
		}
	};

	TncPosition.prototype.applyPosition = function($e) {
		var self = this;

		self.load();

		var o = {
			left : self.left + '%',
			top : self.top + '%',
			width : self.width + '%',
			height : self.height + '%',
			zIndex : self.zIndex
		};
		$e.css(o);
	};

	return TncPosition;
});
