define([], function() {
	'use strict';
	var module = {};

	// shuffle array random using Fisher-Yates
	module.shuffle = function(array) {
		var tmp, current, top = array.length;
		if (top) {
			while (--top) {
				current = Math.floor(Math.random() * (top + 1));
				tmp = array[current];
				array[current] = array[top];
				array[top] = tmp;
			}
		}
		return array;
	};

	module.forEach = function(arr, f) {
		for (var i = 0; i < arr.length; i += 1) {
			f(arr[i], i, arr);
		}
	};

	module.forIn = function(obj, f) {
		var i = 0;
		for ( var p in obj) {
			if (obj.hasOwnProperty(p)) {
				f(obj[p], p, i++);
			}
		}
	};

	module.forTimes = function(count, func) {
		for (var i = 0; i < count; i += 1) {
			func(i);
		}
	};

	module.groupBy = function(array, f) {
		var groups = {};
		array.forEach(function(o) {
			var group = JSON.stringify(f(o));
			groups[group] = groups[group] || [];
			groups[group].push(o);
		});
		return Object.keys(groups).map(function(group) {
			return groups[group];
		});
	};

	// 'groupBy' example:
	//	var groupedOrders = groupBy(orders, function(order) {
	//		var date = null;
	//		var orderDate = order.Afleverdatum;
	//		if (orderDate) {
	//			date = new Date(orderDate.getFullYear(), orderDate.getMonth(), orderDate.getDate())
	//		}
	//		return [ order.Ordernummer, date ];
	//	});

	return module;
});