define([ 'tools/tools' ], function() {
	'use strict';
	var module = {};
	var tools = require('tools/tools');
	var format = tools.format;
	var pad = tools.pad;

	module.parseDate = function(dateStr) {
		var dateRegex = /([0-9]*)-([0-9]*)-([0-9]*)T(.*)/gi;
		var match = dateRegex.exec(dateStr);
		if (match) {
			return new Date(parseInt(match[1]), parseInt(match[2]) -1, parseInt(match[3]));
		}
		return null;
	};

	module.getBirthdays = function(dateArr, dateProp) {
		var now = new Date();
		var nowYear = now.getFullYear();
		var nowDate = now.getDate();
		var nowMonth = now.getMonth();

		var result = [];

		dateArr.forEach(function(item) {
			var itemDate = item[dateProp];
			var date = itemDate.getDate();
			var month = itemDate.getMonth();
			var year = itemDate.getFullYear();

			var birthDay = null;
			var birthDayYear = null;

			if (month < nowMonth || (month == nowMonth && date < nowDate)) {
				birthDayYear = nowYear+1;
			} else {
				birthDayYear = nowYear;
			}
			birthDay = new Date(birthDayYear, month, date);

			var row = {};
			row.birthDay = birthDay;
			row.birthDayAge = birthDayYear - year;
			row.timeToBirthDay = birthDay.valueOf() - now.valueOf();
			row.data = item;
			result.push(row);
		});

		result.sort(function(a, b) {
			return a.timeToBirthDay - b.timeToBirthDay;
		});

		return result;
	};

	module.formatDate = function(date, format) {
		var dstr = format;
		dstr = dstr.replace('yyyy', date.getFullYear());
		dstr = dstr.replace('yy', pad(date.getYear(), 2));
		dstr = dstr.replace('y', date.getYear());

		dstr = dstr.replace('MM', pad(date.getMonth(), 2));
		dstr = dstr.replace('M', date.getMonth());

		dstr = dstr.replace('dd', pad(date.getDate(), 2));
		dstr.replace('d', date.getDate());

		dstr = dstr.replace('HH', pad(date.getHours(), 2));
		dstr = dstr.replace('H', date.getHours());

		dstr = dstr.replace('hh', pad(date.getHours() % 12, 2));
		dstr = dstr.replace('h', date.getHours() % 12);

		dstr = dstr.replace('mm', pad(date.getMinutes(), 2));
		dstr = dstr.replace('m', date.getMinutes());

		dstr = dstr.replace('ss', pad(date.getSeconds(), 2));
		dstr = dstr.replace('s', date.getSeconds());

		dstr = dstr.replace('fff', pad(date.getMilliseconds(), 3));
		return dstr;
	};

	module.datesEqual = function(a, b) {
		return a.getDate() === b.getDate() && a.getMonth() === b.getMonth() && a.getFullYear() === b.getFullYear();
	};

	module.isToday = function(date) {
		if (date && date.getFullYear) {
			return module.datesEqual(new Date(), date);
		}
		return false;
	};

	module.minToHour = function(min) {
		return min * (100 / 60) / 100;
	};

	module.hourToMin = function(hour) {
		return (hour / (100 / 60)) * 100;
	};

	var to_min = (100 / 60) / 100;
	var to_sec = (100 / 60) / 10000;
	module.getTimeNumber = function(date) {
		if (date && date.getHours) {
			return date.getHours() + (date.getMinutes() * to_min) + (date.getSeconds() * to_sec);
		}
		return 0;
	};

	module.dateToStr = function(time) {
		return format('{0}-{1}-{2} {3}:{4}', pad(time.getFullYear(), 4), pad(time.getMonth(), 2), pad(time.getDate(), 2), time.getHours(), pad(time
				.getMinutes(), 2));
	};

	module.getWeek = function(date) {
		var onejan = new Date(date.getFullYear(), 0, 1);
		return Math.ceil((((date - onejan) / 86400000) + onejan.getDay() + 1) / 7);
	};

	module.dayNames = [ 'zondag', 'maandag', 'dinsdag', 'woensdag', 'donderdag', 'vrijdag', 'zaterdag' ];
	module.monthNamesFull = [ 'januari', 'februari', 'maart', 'april', 'mei', 'juni', 'juli', 'augustus', 'september', 'oktober', 'november', 'december' ];
	module.monthNames = [ 'jan', 'feb', 'mrt', 'april', 'mei', 'juni', 'juli', 'aug', 'sept', 'okt', 'nov', 'dec' ];
	var monthNames = module.monthNames;

	module.shortDateStr = function(date) {
		if (date && date.getFullYear) {
			return format('{1}  {0}', monthNames[date.getMonth()], pad(date.getDate(), 2));
		}
	};

	module.dateToString = function(date) {
		if (date && date.getFullYear) {
			return format('{0}-{1}-{2}  {3}:{4}:{5}', pad(date.getFullYear(), 4), pad(date.getMonth() + 1, 2), pad(date.getDate(), 2), pad(date.getHours(), 2),
					pad(date.getMinutes(), 2), pad(date.getSeconds(), 2));
		}
		return '';
	};

	module.addDays = function(date, days) {
		var result = new Date(date);
		result.setDate(date.getDate() + days);
		return result;
	};
	var addDays = module.addDays;

	module.isWorkingDay = function(date) {
		var weekDay = date.getDay();
		return !(weekDay == 0 || weekDay == 6);
	};
	var isWorkingDay = module.isWorkingDay;

	module.addWorkingDays = function(date, days) {
		var result = new Date(date);
		var step = 1;
		if (days < 0)
			step = -1;

		var cnt = Math.abs(days);
		while (cnt > 0) {
			result = addDays(result, step);
			if (isWorkingDay(result)) {
				cnt--;
			}
		}
		return result;
	};

	module.getTimeAsSeconds = function getTimeAsSeconds(date) {
		if (date && date.getHours) {
			return (date.getHours() * 3600) + (date.getMinutes() * 60) + date.getSeconds();
		}
		return null;
	};

	return module;
});
