define(['bluebird'], function () {
    'use strict';
    var Promise = require('bluebird');

    var module = {};
    module.calculateSizeToFit = function (target, current) { // targetWidth,
        // targetHeight,
        // currentWidth,
        // currentHeight
        var ratioX = target[0] / current[0];
        var ratioY = target[1] / current[1];
        var ratio = Math.min(ratioX, ratioY);

        var newWidth = Math.floor(current[0] * ratio);
        var newHeight = Math.floor(current[1] * ratio);

        var centerX = Math.floor((target[0] - newWidth) / 2);
        var centerY = Math.floor((target[1] - newHeight) / 2);

        return {
            size: [newWidth, newHeight],
            center: [centerX, centerY]
        };
    };

    module.preloadImages = function (images, done) {
        var arr = images;
        var arrLoaded = [];

        function loadImage(src) {
			// Wait for the image to be fully loaded
            var img = new Image();
            img.src = src;

			var loaded = function() {
				arrLoaded.push(src);
                if (arrLoaded.length == arr.length) {
					img.onload = null;
					img.onerror = null;
					arrLoaded = null;
                    img = null;
                    done();
                }
			};
            img.onload = loaded;
            img.onerror = loaded;
        }
        for (var i = 0; i < arr.length; i += 1) {
            loadImage(arr[i]);
        }
    };

    module.preloadImage = function(src) {
        return new Promise(function(resolve, reject) {
            var img = new Image();
            img.src = src;
            img.onload = function() { resolve(img); };
            img.onerror = reject;
        });
    };

    // var img = new Image();
    // img.crossOrigin = "Anonymous"; //cors support
    // img.onload = function () {
    //
    // }
    // img.src = 'http://i.imgur.com/8VsK7gS.png';

    module.resizeImage = function (img) {
        //var img = new Image();
        var W = img.width;
        var H = img.height;

        var canvas = document.createElement('canvas');
        var ctx = canvas.getContext("2d");
        canvas.width = W;
        canvas.height = H;
        ctx.drawImage(img, 0, 0); //draw image

        //resize by ratio
        //var ratio = 0.93895525; //from 0 to 1
        //resample_hermite(canvas, W, H, Math.round(W * ratio), Math.round(H * ratio));
        //
        var c = module.calculateSizeToFit([400, 400], [W, H]);

        //resize manually
        module.resample_hermite(canvas, W, H, c.size[0], c.size[1]);
        return canvas.toDataURL();
    };

    module.resample_hermite = function (canvas, W, H, W2, H2) {
        //var time1 = Date.now();
        W2 = Math.round(W2);
        H2 = Math.round(H2);
        var img = canvas.getContext("2d").getImageData(0, 0, W, H);
        var img2 = canvas.getContext("2d").getImageData(0, 0, W2, H2);
        var data = img.data;
        var data2 = img2.data;
        var ratio_w = W / W2;
        var ratio_h = H / H2;
        var ratio_w_half = Math.ceil(ratio_w / 2);
        var ratio_h_half = Math.ceil(ratio_h / 2);

        for (var j = 0; j < H2; j++) {
            for (var i = 0; i < W2; i++) {
                var x2 = (i + j * W2) * 4;
                var weight = 0;
                var weights = 0;
                var weights_alpha = 0;
                var gx_r = 0,
                    gx_g = 0,
                    gx_b = 0,
                    gx_a = 0;
                var center_y = (j + 0.5) * ratio_h;
                for (var yy = Math.floor(j * ratio_h); yy < (j + 1) * ratio_h; yy++) {
                    var dy = Math.abs(center_y - (yy + 0.5)) / ratio_h_half;
                    var center_x = (i + 0.5) * ratio_w;
                    var w0 = dy * dy; //pre-calc part of w
                    for (var xx = Math.floor(i * ratio_w); xx < (i + 1) * ratio_w; xx++) {
                        var dx = Math.abs(center_x - (xx + 0.5)) / ratio_w_half;
                        var w = Math.sqrt(w0 + dx * dx);
                        if (w >= -1 && w <= 1) {
                            //hermite filter
                            weight = 2 * w * w * w - 3 * w * w + 1;
                            if (weight > 0) {
                                dx = 4 * (xx + yy * W);
                                //alpha
                                gx_a += weight * data[dx + 3];
                                weights_alpha += weight;
                                //colors
                                if (data[dx + 3] < 255)
                                    weight = weight * data[dx + 3] / 250;
                                gx_r += weight * data[dx];
                                gx_g += weight * data[dx + 1];
                                gx_b += weight * data[dx + 2];
                                weights += weight;
                            }
                        }
                    }
                }
                data2[x2] = gx_r / weights;
                data2[x2 + 1] = gx_g / weights;
                data2[x2 + 2] = gx_b / weights;
                data2[x2 + 3] = gx_a / weights_alpha;
            }
        }
        //console.log("hermite = " + (Math.round(Date.now() - time1) / 1000) + " s");
        canvas.getContext("2d").clearRect(0, 0, Math.max(W, W2), Math.max(H, H2));
        canvas.width = W2;
        canvas.height = H2;
        canvas.getContext("2d").putImageData(img2, 0, 0);
        //return img2;
    };

    return module;
});
