define([ 'jquery' ], function(jQuery) {
	'use strict';
	var module = {};
	var $ = jQuery;

	// Helper functie die een nieuw html element aanmaakt en deze als jQuery
	// object terug geeft
	module.$new = function(type, parent, attributes, classNames) {
		var k, i;
		var el = document.createElement(type);
		if (attributes && attributes['type']) {
			el.type = attributes['type'];
		}

		$(parent).append(el);
		var jqEl = $(el);

		if (attributes) {
			for (k in attributes) {
				if (k !== 'type') {
					jqEl.attr(k, attributes[k]);
				}
			}
		}

		if (classNames && classNames instanceof Array) {
			for (i = 0; i < classNames.length; i += 1) {
				jqEl.addClass(classNames[i]);
			}
		}

		return jqEl;
	};

	module.$newCss = function(file, $head) {
		var $h = $('head');

		if ($head) {
			$h = $head;
		}

		var $e = module.$new('link', $h, {
			'rel' : 'stylesheet',
			'type' : 'text/css',
			'href' : file
		});
		return $e;
	};

	module.$newJs = function(file, $head) {
		var $h = $('head');

		if ($head) {
			$h = $head;
		}

		var $e = module.$new('script', $h, {
			'type' : 'text/javascript',
			'src' : file
		});
		return $e;
	};

	module.$redraw = function($e) {
		return $e.hide(0, function() {
			$e.show(0);
		});
	};

	return module;
});
