define([ 'tools/tools', 'tools/numbers' ], function() {
	'use strict';
	var module = {};

	var tools = require('tools/tools');
	var numbers = require('tools/numbers');
	var format = tools.format;
	var round100 = numbers.round100;

	module.isString = function(o) {
		if (typeof o === 'string' || o instanceof String) {
			return true;
		}
		return false;
	};

	var isString = module.isString;

	module.isNumber = function(o) {
		if (typeof o === 'number') {
			return !isNaN(o);
		}
		return false;
	};

	var isNumber = module.isNumber;

	module.getHex = function(num) {
		return parseInt(num, 16);
	};

	var getHex = module.getHex;

	module.getColor = function(setting, def) {
		if (typeof setting === 'string' && setting != '') {
			if (setting.length == 9) {
				var rgbaHex = /#([0-9A-F]{2})([0-9A-F]{2})([0-9A-F]{2})([0-9A-F]{2})/gi;
				var match = rgbaHex.exec(setting);
				if (match) {
					var color = format('rgba({0}, {1}, {2}, {3})', getHex(match[1]), getHex(match[2]), getHex(match[3]), round100(getHex(match[4]) / 255.0));
					return color;
				}
			}

			return setting;
		} else {
			return def;
		}
	};

	module.getStr = function(setting, def) {
		if (typeof setting === 'string' && setting != '') {
			return setting;
		} else {
			return def;
		}
	};

	module.getArray = function(setting, def) {
		if (setting && setting.constructor === Array) {
			return setting;
		}
		return def;
	};

	module.getNum = function(setting, def) {
		if (isNumber(setting)) {
			return setting;
		} else if (isString(setting) && setting != '') {
			var f = parseFloat(setting);
			if (!isNaN(f)) {
				return f;
			}
			return def;
		} else {
			return def;
		}
	};

	return module;
});
