define([
    'knockout',
    'jquery',
    'bluebird',
    'tools/all',
    'tnc/tnc-border',
    'tnc/tnc-margin',
    'widgets/transformation/ViewModel',
    'widgets/transformation/DeferredPromise'
],
function () {
    'use strict';

    var Promise = require('bluebird');
    var $ = require('jquery');
    var allTools = require('tools/all');
    var arrays = allTools.arrays;
    var tools = allTools.tools;
    var log = tools.log;
    var jqTools = allTools.jqTools;
    var $new = jqTools.$new;
    var limitOpacity = tools.limitOpacity;
    var validate = allTools.validate;
    var getColor = validate.getColor;
    var TncBorder = require('tnc/tnc-border');
    var TncMargin = require('tnc/tnc-margin');
    var ViewModel = require('widgets/transformation/ViewModel');
    var ko = require("knockout");
    var DeferredPromise = require('widgets/transformation/DeferredPromise');

    var TransformationPageItem = function(data, itemInfo, pageWindow) {
        var self = this;

        self.preload = function () {
            return Promise.resolve();
        };

        $.extend(self, data);

        self.pageWindow = pageWindow;
        self.itemInfo = itemInfo;

        var pageFinishedPlayingDeferredPromise = new DeferredPromise();
        self.finished = pageFinishedPlayingDeferredPromise.promise;
        self.setFinished = function() {
            pageFinishedPlayingDeferredPromise.resolve();
        };

        self.play = function() {
            var itemStartEvent = new CustomEvent('itemStart', { detail: self });
            self.pageWindow.dispatchEvent(itemStartEvent);


            console.log('play item duration', self.itemInfo.pageDuration); 
            setTimeout(function() {
                self.setFinished();
            }, self.itemInfo.pageDuration);

            return self.finished
                .finally(function() {
                    var itemEndEvent = new CustomEvent('itemEnd', { detail: self });
                    self.pageWindow.dispatchEvent(itemEndEvent);
                });
        };
    };

    return TransformationPageItem;
});
