define([
    'knockout',
    'widgets/transformation/ViewModelValue',
    'lib/moment-with-locales'
],
function () {
    'use strict';

    var ViewModelValue = require('widgets/transformation/ViewModelValue');

    var moment = require('lib/moment-with-locales');
    var ko = require("knockout");


    function ViewModel(pageInfo, data, resolveRelativeUrl) {
        var vm = this;

        vm.data = new ViewModelValue(data, 10, resolveRelativeUrl);
        vm.resolveUrls = function (host, v) {
            var str = '' + v;
            str = str.replace(/(["'>])(\/.*?)(["'<])/g, function (a, b, c, d) {
                return b + (host + c) + d;
            });
            return str;
        };

        vm.pageIndex = ko.observable(pageInfo.pageIndex);
        vm.pageOffset = ko.observable(pageInfo.pageIndex * pageInfo.pageSize);
        vm.pageCount = ko.observable(pageInfo.pageCount);

        vm.moment = moment;

        vm.items = ko.observableArray([]);

        vm.pageReadyToPlay = ko.observable(false);
        // Ensure it notifies about changes no more than once
        // per one second
        vm.items.extend({
            rateLimit: 20
        }); // scheelt een hoop schokken in de animaties

        vm.onAfterRender = function () {
            pageInfo.page.setRendered();
        };

        vm.rawItems = pageInfo.rawPageItems;
        vm.params = pageInfo.params;
        vm.paramDisplayNames = pageInfo.paramDisplayNames;        
        
        var items = pageInfo.pageItems;

        for (var j = 0; j < items.length; j += 1) {
            var itemData = items[j];

            var item = new ViewModelValue(itemData, 10, resolveRelativeUrl);
            vm.items.push(item);
        }
    }

    return ViewModel;
});
