define([
    'tnc/tnc-tools'
],
function () {
    'use strict';

    var tncTools = require('tnc/tnc-tools');
    var isUrl = tncTools.isUrl;

    var ViewModelValue = function (dataVal, len, resolveRelativeUrl) {
 
        var self = this;
        self._strval = null;
        self._data = dataVal;
        self.init(dataVal, len, resolveRelativeUrl);
    };

    ViewModelValue.prototype.init = function (data, len, resolveRelativeUrl) {
        var self = this;
        if (typeof (this._data) === 'string') {
            if (isUrl(this._data)) {
                self._strval = resolveRelativeUrl(this._data);
            }
        }

        if (data instanceof Object) {
            for (var p in data) {
                if (data.hasOwnProperty(p)) {
                    if (Array.isArray(data[p])) {
                        self[p] = data[p];
                    } else {
                        self[p] = new ViewModelValue(data[p], len - 1, resolveRelativeUrl);
                    }
                }
            }

            if ('#text' in data) {
                var text = data['#text'];
                if (isUrl(text)) {
                    self._strval = resolveRelativeUrl( text);
                } else {
                    self._strval = text;
                }
            } else if ('#cdata-section' in data) {
                var cdata = data['#cdata-section'];
                if (isUrl(cdata)) {
                    self._strval = resolveRelativeUrl( cdata);
                } else {
                    self._strval = cdata;
                }
            }
        }
    };

    ViewModelValue.prototype.toString = function () {
        var self = this;
        if (self._strval) {
            return self._strval;
        }
        return self._data;
    };

    return ViewModelValue;

});