define(['knockout', 'bluebird', 'jquery', 'require-videojs', 'tnc/tnc-tools'],
function () {
    'use strict';

    var ko = require("knockout");
    var Promise = require('bluebird');
    var $ = require('jquery');

    var tncTools = require('tnc/tnc-tools');
    var videojs = window.videojs;

    var VideoComponent = function (params) {
        var self = this;
        self.widget = params.widget;
        self.$element = $(params.element);

        self.sources = ko.observableArray([]);

        $('head').append('<link href="theme/video/video-js.min.css" rel="stylesheet"/>');
        var loadWidget = function() {

            if (self.widget.settings.template.novideo) {
                self.widget.setLoaded();
                $('.disabled-video-icon').css({ visibility: 'visible' });
                return;
            }

            setTimeout(function() {
                $('.no-video-icon').css({ visibility: 'visible' });
            }, 3000)

            var notPlayingTimeout = setTimeout(function () {
                var isPlaying = (self.player && self.player.currentTime() > 0);
                if (!isPlaying)
                {
                    self.widget.setPlayed();
                } else {
                    $('.no-video-icon').css({ display: 'none' });
                    $('.video-container').css({ visibility: 'visible' });
                }
            }, 7000);

            var sources = [];

            if (self.widget.settings.data.videoType === "stream") {
                sources = [{
                    src: self.widget.settings.data.url,
                    type: self.widget.settings.data.mimeType || 'application/x-mpegURL'
                }];
            }

            if (self.widget.settings.data.videoType === "lokaal") {
                var videoUrl = tncTools.resourceUrl(self.widget.settings.templateFolder, self.widget.settings.data.url);

                sources = [{
                    src: videoUrl,
                    type: self.widget.settings.data.mimeType  || 'video/mp4'
                }];
            }

            var videojsSettings = {
                sources: sources
            };
            videojs('video-player1', videojsSettings).ready(function() {
                self.player = this;
                self.player.on('error', function(err){
                    self.widget.setPlayed();
                });

                self.player.on('loadeddata', function() {
                    clearTimeout(notPlayingTimeout);
                    $('.no-video-icon').css({ display: 'none' });
                    $('.video-container').css({ visibility: 'visible' });
                });

                self.widget.setLoaded();
            });
        };
        loadWidget();

        self.widget.onplay = function() {
            if (self.player)
            {
                if (self.widget.settings && self.widget.settings.duration >= 1)
                {
                    setTimeout(function() {
                        self.widget.setPlayed();
                    }, self.widget.settings.duration)
                }

                self.player.on('ended', function() {
                    $('.video-container').css({ display: 'none' });
                    self.widget.setPlayed();
                  });
                self.player.play();
            }
            else
            {
                var duration = 10000;
                if (self.widget.settings && self.widget.settings.duration >= 1)
                {
                    duration = self.widget.settings.duration;
                }
                setTimeout(function() {
                    self.widget.setPlayed();
                }, duration);
            }
        };

        self.widget.sendInitialized();
    };
    return VideoComponent;
});
