define(['knockout', 'bluebird', 'jquery', 'tnc/tnc-tools'],
    function() {
        'use strict';

        var ko = require("knockout");
        var Promise = require('bluebird');
        var $ = require('jquery');
        var tncTools = require('tnc/tnc-tools');


        var WebPageComponent = function(params) {
            var self = this;
            self.widget = params.widget;
            self.$element = $(params.element);

            var loadWidget = function() {
                var url = '';
                if (self.widget.settings && self.widget.settings.data && self.widget.settings.data.url)
                {
                    url = self.widget.settings.data.url;
                }

                $('iframe', self.$element).attr('src', url);


                setTimeout(function() {
                    self.widget.setLoaded();
                }, 500);
            };
            loadWidget();

            self.widget.onplay = function() {
                var duration = 0;
                if (self.widget.settings && self.widget.settings.duration) {
                    duration = self.widget.settings.duration;
                }

                setTimeout(function() {
                    self.widget.setPlayed();
                }, duration);
            };

            self.widget.sendInitialized();
        };
        return WebPageComponent;
    });
