require.config({
    baseUrl: 'theme/',
    shim: {
        'videojs-contrib-hls': {
            deps: ['require-videojs']
        },
        'videojs-youtube': {
            deps: ['require-videojs']
        },
        'videojs-vimeo': {
            deps: ['require-videojs']
        }
    },
    paths: {
        bluebird: 'bluebird.min',
        'require-videojs': 'widgets/require-video',
        'videojs': 'video/video.min',
        'videojs-youtube': 'video/videojs-youtube.min',
        'videojs-vimeo': 'video/videojs-vimeo',
        'videojs-contrib-hls': 'video/videojs-contrib-hls.min'
    }
});
require(['knockout', 'jquery', 'model/ChildWidget', 'widgets/widget-components'],
function() {

    var ko = require('knockout');
    var $ = require('jquery');
    var ChildWidget = require('model/ChildWidget');

    var ErrorHandlingBindingProvider = function() {
        var original = new ko.bindingProvider();
        //determine if an element has any bindings
        this.nodeHasBindings = original.nodeHasBindings;
        //return the bindings given a node and the bindingContext
        this.getBindingAccessors = function(node, bindingContext) {
            var result = {};
            //catch general errors parsing binding syntax
            try {
                result = original.getBindingAccessors(node, bindingContext);
            } catch (e) {
                if (console && console.log) {
                    console.log("Error in binding syntax: " + e.message, node);
                }
            }
            //catch errors when actually evaluating the value of a binding
            ko.utils.objectForEach(result, function (key, value) {
                result[key] = function() {
                    var result = null;
                    try {
                        result = value();
                    } catch (e) {
                        if (console && console.log) {
                            console.log("Error in \"" + key + "\" binding: " + e.message, node);
                        }
                    }
                    return result;
                };
            });
            return result;
        };
    };
    ko.bindingProvider.instance = new ErrorHandlingBindingProvider();

    ko.unapplyBindings = function ($node, remove) {
        // unbind events
        $node.find("*").each(function () {
            $(this).unbind();
        });

        // Remove KO subscriptions and references
        if (remove) {
            ko.removeNode($node[0]);
        } else {
            ko.cleanNode($node[0]);
        }
    };

    var loadComponent = function(component, widget) {
        var $e = $('<div class="ko-component" data-bind=\'component: { name: "' + component + '", params: params }\'></div>');
        $('body').append($e);
        var viewModel = {
            params: {
                element: $e[0],
                widget: widget
            }
        };
        ko.applyBindings(viewModel, $e[0]);
    };

    var getComponentForVideoWidget = function(videoType) {
        switch (videoType) {
            case 'vimeo':
                component = 'widget-vimeo';
                break;
            case 'youtube':
                component = 'widget-youtube';
                break;
            case 'lokaal':
                component = 'widget-video';
                break;
            case 'stream':
                component = 'widget-video';
            default:
                component = 'widget-video';
        };
        return component;
    };

    var getComponentForWidget = function(settings) {
        var dataType = ('' + settings.data.dataType).toLowerCase();
        var videoType = ('' + settings.data.videoType).toLowerCase();
        switch (dataType) {
            case 'image':
                component = 'widget-knockout';
                break;
            case 'video':
                component = getComponentForVideoWidget(videoType);
                break;
            case 'knockout':
                component = 'widget-transformation';
                break;
            case 'maatwerk':
                component = 'widget-maatwerk';
                break;
            case 'webpage':
                component = 'widget-webpage';
                break;
            case 'html':
                component = 'widget-html';
                break;
            default:
                component = 'widget-html';
                break;
        };
        return component;
    };

    var childWidget = new ChildWidget();
    childWidget.onload = function(settings) {
        var component = getComponentForWidget(childWidget.settings);
        loadComponent(component, childWidget);
    };
    childWidget.sendInitialized();
});
