(function() {
    var InfoService = function() {
        // validation
        if (!window.services.settingService) throw "InfoService > The settingService isn't loaded.";
        var settingsService = window.services.settingService;

        var napiUrl = settingsService.getValue('napiUrl');
       

        var self = this;

        self.getNapiUrl = function() {
            return $.getJSON(napiUrl + 'api/config').then(function(data) {
                return data.settings.apiBaseUrl;
            });
        }

        self.getAdditionalInfo = function() {
            return $.getJSON(napiUrl + 'api/info').then(function(data) {               
                return data;
            });
        }

        self.getApiAvailability = function(apiUrl) {
            return new Promise(function(resolve, reject) {
                $.getJSON(apiUrl + 'api/status/isRunning')
                .success(function() { resolve(true); })
                .error(function() { resolve(false); });
            });
        }

        self.updateConfigSetting = function(key, value) {
            return new Promise(function(resolve, reject) {
                key = encodeURIComponent(key);
                value = encodeURIComponent(value);
                var url = napiUrl + 'api/config/edit/' + key + '/' + value;

                $.ajax({
                    url: url,
                    type: 'PUT',
                    success: function(data) {
                        resolve();
                    }
                });
            });
        }

    }

    window.services = window.services || {};
    window.services.infoService = window.services.infoService || new InfoService();
}());
