define(['bluebird', 'service/xmlDataService', 'service/queryDataService', 'tnc/tnc-tools'], function () {
    var Promise = require('bluebird');

    var xmlDataService = require('service/xmlDataService');
    var queryDataService = require('service/queryDataService');
    var tncTools = require('tnc/tnc-tools');

    var exports = {};

    exports.getWidgetData = function (parentSettings, widgetSettings) {

        var dataType = widgetSettings.knockoutDataType.toLowerCase();
        var queries = widgetSettings.queries;
        var templateFolder = parentSettings.templateFolder;
        var maxItems = widgetSettings.maxNumberOfItems || 0;
        var xmlUrl = tncTools.resourceUrl(parentSettings.templateFolder, parentSettings.id + '.xml');
        var loadFromDataXml = (parentSettings.template.enableEdit || parentSettings.template.exampleItems) || false;
        var dataXml = widgetSettings.dataXml;
        var dataItemPath = 'rss.channel.item';
        if (widgetSettings.countPath && widgetSettings.countPath !== '') {
            dataItemPath = widgetSettings.countPath;
        }

        var params = widgetSettings.params;
        var paramDisplayNames = widgetSettings.paramDisplayNames;

        var promise = Promise.resolve({});
        switch (dataType) {
            case 'rss':
                // als het rss is zijn er 2 mogelijkheden: voorbeeld items (in edit mode) of
                // echte data gedownload door de URLDownloader.exe die staat in een relatief xml bestand
                dataItemPath = 'rss.channel.item';
                if (loadFromDataXml) {
                    promise = xmlDataService.loadXmlDataFromString(dataXml);
                } else {
                    promise = xmlDataService.loadXmlData(xmlUrl);
                }
                break;
            case 'transformation':
                // Dit is een transformation: laad diverse 'queries', waarbij een 'query' 3 dingen kan zijn:
                // 1) een jquery ajax instellingen object
                // 2) een maatwerk sleutel
                // 3) een javascript functie, met toegang tot jquery, moment en promises
                promise = queryDataService.loadDataMultipleQueries(queries, templateFolder, params, paramDisplayNames);
                break;
            default:
                promise = Promise.resolve({});
        }

        var minute = 1000 * 60;
        return promise
            .timeout(minute * 10)
            .then(function (result) {

                if (dataItemPath.indexOf('queries.') !== 0) {
                  dataItemPath = 'queries.' + dataItemPath;
                }

                var items = tncTools.queryObject(result, dataItemPath);
                if (maxItems > 0) {
                    items = items.splice(0, maxItems);
                }
                return {
                    items: items,
                    data: result
                };
            })
            .catch(function (err) {
                console.error('error while loading transformation data', err);
                return Promise.resolve({
                    items: [],
                    data: {}
                });
            });
    };

    return exports;
});
