define(['bluebird', 'service/xhrService', 'tnc/tnc-tools'], function () {
    var Promise = require('bluebird');
    var xhrService = require('service/xhrService');
    var tncTools = require('tnc/tnc-tools');

    var exports = {};

    exports.loadXmlDataFromString = function (xmlString) {
        return new Promise(function (resolve, reject) {
            resolve(tncTools.parseXml(xmlString));
        });
    };

    exports.loadXmlDataFromUrl = function (url) {
        return xhrService.request(url)
            .then(function(xhr) {
                var xmlStr = xhr.responseText;
                return exports.loadXmlDataFromString(xmlStr);
            });
    };

    return exports;
});
