﻿define(['bluebird.min'], function () {

    var Macro = function (name, action, documentation) {
        // validating parameters
        if (typeof name != "string") {
            console.error("The parameter 'name' for the constructor of Macro should be of type String");
        }

        if (name == null || typeof name == 'undefined') {
            console.error("The paramater 'name'for the constructor of Macro cannot be null or undefined");
        }

        // the constructor
        var self = this;

        self.name = name;
        self.action = action;
        self.helpers = {};
        self.helpers.Promise = require('bluebird.min');
        self.documentation = documentation;
    };

    Macro.prototype.resolve = function (args) {
        return this.action(args);

    };

    return Macro;

});
