define(['jquery', 'knockout'], function () {
    var $ = require('jquery');
    var ko = require('knockout');

    window.loadJson = function (json) {

        if (typeof json == 'undefined') return;
        if (json.ActiveData) {
            exports.cacheFolder = json.ActiveData;
            var folderPath = exports.themeFolder == '' ? '' : exports.themeFolder + '/';
            if (exports.cacheFolder && exports.cacheFolder !== '') {
                loadScriptsNoCache([folderPath + exports.dataFolder + '/' + exports.cacheFolder + '/output.js']);
            } else {
                loadScriptsNoCache([folderPath + exports.dataFolder + '/output.js']);
            }
        } else {

            exports.data = json;
            exports.items.push(json);
            while (exports.callbacks.length > 0) {
                var cb = exports.callbacks.pop();

                cb({ query: null, xhr: null, result: json });
            }
        }
    };

    var loadScriptsNoCache = function (uris, whenDone) {
        var i;
        for (i = 0; i < uris.length; i += 1) {
            uris[i] = uris[i] + '?_=' + Math.random();
        }
        loadScripts(uris, whenDone);
    };

    var loadScripts = function (uris, whenDone) {
        if (!uris.length) {
            whenDone && whenDone();
        } else {
            for (var wait = [], i = uris.length; i--;) {
                var tag = document.createElement('script');
                tag.type = 'text/javascript';
                tag.src = uris[i];
                if (whenDone) {
                    wait.push(tag);
                    tag.onload = maybeDone;
                    tag.onreadystatechange = maybeDone; // For IE8-
                }
                document.head.appendChild(tag);
            }
        }
        var maybeDone = function () {
            if (this.readyState === undefined || this.readyState === 'complete') {
                for (var i = wait.length; i--;) if (wait[i] == this) wait.splice(i, 1);
                if (!wait.length) whenDone();
            }
        };
    };

    var exports = {};
    exports.callbacks = [];
    exports.data = null;
    exports.dataFolder = '';
    exports.themeFolder = '';
    exports.items = [];
    exports.cacheFolder = '';

    exports.formatAppParameters = function (data) {

        var appParameters = {};

        if (!!(data && data.appParameters)) {
            var p = data.appParameters;
            for (var i = 0; i < p.length - 1; i++) {
                appParameters[p[i].Name] = p[i].Value;
            }
        }
        return appParameters;
    }

    exports.createAndSetDataObject = function (data, options) {
        var folder = '';
        if (options.folder && options.folder != '') {
            folder = options.folder + '/';
        }

        var newData = {
            rootFolder: folder,
            appParameters: exports.formatAppParameters(data)
        };

        options.data = newData;
    };

    exports.processData = function (data, callback) {

        exports.items.push(result.items);
        callback(result);


    };

    exports.getData = function (callback) {

        exports.callbacks.push(callback);

        if (exports.themeFolder && exports.themeFolder !== '') {
            loadScriptsNoCache([exports.themeFolder + '/' + exports.dataFolder + '/output.js']);
        } else {
            loadScriptsNoCache([exports.dataFolder + '/output.js']);
        }
    };

    return exports;

});
