define(['tools/tools'], function() {
	'use strict';
	var module = {};
	var tools = require('tools/tools');

	module.sendTo = function(contentWindow, data) {
		contentWindow.postMessage(tools.toJson(data), '*');
	};

	module.sendToFrame = function(frame, data) {
		frame.contentWindow.postMessage(tools.toJson(data), '*');
	};

	module.sendToParent = function(data) {
		window.parent.postMessage(tools.toJson(data), '*');
	};

	module.receiveMessage = function(event, handler) {
		// event.origin, event.data, event.source
		var data = JSON.parse(event.data);
		handler(data, event, handler);
	};

	module.registerHandler = function(handler) {
		window.addEventListener("message", function(event) {
			module.receiveMessage(event, handler);
		}, false);
	};

	return module;
});
