define([ 'jquery', 'tools/numbers' ], function() {
	'use strict';
	var module = {};
	//var $ = require('jquery');
	var numbers = require('tools/numbers');
	var round100 = numbers.round100;

	module.deg2rad = function(degrees) {
		return degrees * (Math.PI / 180);
	};
	var deg2rad = module.deg2rad;

	module.rad2deg = function(radians) {
		return radians * (180 / Math.PI);
	};
	//var rad2deg = module.rad2deg;

	module.rotate3dtransform = function($e, radius, property, angle, duration) {
		$e.css('transition', 'none');

		// setTimeout(function() {

		if (!radius || isNaN(radius)) {
			radius = 0;
		}

		var rotate3d;
		if (property == 'rotateY') {
			rotate3d = '0,1,0,' + angle + 'deg';
		} else {
			rotate3d = '1,0,0,' + angle + 'deg';
		}

		var transforms = [];
		// transforms.push('perspective(1000px)');
		// transforms.push('translate3d(0,0,'+ roundPerc(radius * -1) +'px)');
		transforms.push('rotate3d(' + rotate3d + ')');

		var transform = transforms.join(' ');
		var origin = '50% 50% ' + (-round100(radius)) + 'px';

		$e.css({
			'transition' : 'all ' + duration + 'ms',
			'transform-origin' : origin,
			'transform' : transform
		});
		// }, 100);
	};
	var rotate3dtransform = module.rotate3dtransform;

  module.getRadius = function($element, numFaces, vertical) {
      var $e = $element;
      var $p = $e.parent();

      var w = $p.width();
      var h = $p.height();

      var sideMargin = 0;
      var maxWidth = w + (sideMargin * 2);
      var maxHeight = h;
      var radius = maxWidth / (2 * Math.tan(deg2rad(180 / numFaces)));

      if (vertical) {
        radius = maxHeight / (2 * Math.tan(deg2rad(180 / numFaces)));
      }

      return radius;
  };

	module.create3dpanel = function($element, numFaces, vertical) {
		var $e = $element;
		var $p = $e.parent();

		var w = $p.width();
		var h = $p.height();

		var sideMargin = 0;
		var maxWidth = w + (sideMargin * 2);
		var maxHeight = h;
		var radius = maxWidth / (2 * Math.tan(deg2rad(180 / numFaces)));

		if (vertical) {
			radius = maxHeight / (2 * Math.tan(deg2rad(180 / numFaces)));
		}

		$p.css({
			'transform-style' : 'preserve-3d',
			'transform' : 'perspective(1000px)'
		});
		$e.css({
			'backface-visibility' : 'hidden'
		});
		$e.attr('data-radius', radius);
		rotate3dtransform($e, radius, 'rotateY', 0, 0);
	};

	// module.create3dpoly = function($parent) {
	// 	var $e = $parent;
	// 	var $space3d = $new('div', $e);
	// 	$space3d.addClass('space3d');
	// 	createPolygon($space3d, 4);
	//
	// 	return $space3d;
	// };


	// module.createPolygon = function($e, numFaces) {
	// 	var sideMargin = 0;
	//
	// 	var w = $(window).width();
	// 	var h = $(window).height();
	//
	// 	var maxWidth = w + (sideMargin * 2);
	// 	var maxHeight = h;
	// 	var radius = maxWidth / (2 * Math.tan(deg2rad(180 / numFaces)));
	//
	// 	$('.space3d').css('perspective', (radius + w) + 'px');
	// 	var $poly = $new('div', $e);
	// 	$poly.addClass('poly');
	// 	$poly.width(w);
	// 	$poly.height(h);
	// 	$poly.css('transform', 'translateZ(-' + radius + 'px)');
	//
	// 	var rotation = 0;
	// 	var faces = [];
	//
	// 	for (var i = 0; i < numFaces; i += 1) {
	// 		var $face = $new('div', $poly);
	// 		$face.addClass('face');
	// 		$face.css({
	// 			position : 'absolute',
	// 			left : 0,
	// 			top : 0,
	// 			opacity : 1
	// 		}); // padding: '0 0 0 100px'
	// 		$face.width(w);
	// 		$face.height(h);
	// 		$face.css('transform', 'rotateY(' + rotation + 'deg) translateZ(' + radius + 'px)');
	// 		faces.push({
	// 			origRotation : rotation,
	// 			$face : $face
	// 		});
	// 		rotation += 360 / numFaces;
	// 	}
	// };

	return module;
});
