define([], function() {
	'use strict';
	var module = {};
	module.getQueryParams = function(url) {
		url = url || window.location.href;
		var query = (url.split('?')[1] || '').split('#')[0];
		var queryPattern = /([^&=]+)=?([^&]*)/g;
		var match;

		var params = {};

		while (match = queryPattern.exec(query)) {
			var key = decodeURIComponent(match[1].replace(/\+/g, '%20'));
			var val = match[2];
			if (val) {
				val = decodeURIComponent(match[2].replace(/\+/g, '%20'));
			} else {
				val = '';
			}
			params[key] = val;
		}
		return params;
	};

	module.toAbsoluteURL = function(url) {
		// Handle absolute URLs (with protocol-relative prefix)
		// Example: //domain.com/file.png
		if (url.search(/^\/\//) != -1) {
			return window.location.protocol + url;
		}

		// Handle absolute URLs (with explicit origin)
		// Example: http://domain.com/file.png
		if (url.search(/:\/\//) != -1) {
			return url;
		}

		// Handle absolute URLs (without explicit origin)
		// Example: /file.png
		if (url.search(/^\//) != -1) {
			return window.location.origin + url;
		}

		var href = window.location.href.split('?')[0].split('#')[0];

		// Handle relative URLs
		// Example: file.png
		var base = href.match(/(.*\/)/)[0];
		return base + url;
	};

	module.updateQueryString = function(url, key, value) {
		if (!url)
			url = window.location.href;
		var re = new RegExp('([?&])' + key + '=.*?(&|#|$)(.*)', 'gi');
		var hash;

		if (re.test(url)) {
			if (typeof value !== 'undefined' && value !== null)
				return url.replace(re, '$1' + key + '=' + value + '$2$3');
			else {
				hash = url.split('#');
				url = hash[0].replace(re, '$1$3').replace(/(&|\?)$/, '');
				if (typeof hash[1] !== 'undefined' && hash[1] !== null)
					url += '#' + hash[1];
				return url;
			}
		} else {
			if (typeof value !== 'undefined' && value !== null) {
				var separator = url.indexOf('?') !== -1 ? '&' : '?';
				hash = url.split('#');
				url = hash[0] + separator + key + '=' + value;
				if (typeof hash[1] !== 'undefined' && hash[1] !== null)
					url += '#' + hash[1];
				return url;
			} else
				return url;
		}
	};

	return module;
});
