define([
    'jquery',
    'widgets/transformation/transformationWidgetService'
],
function () {
    'use strict';

    // Libs
    var $ = require('jquery');

    // Services
    var transformationWidgetService = require('widgets/transformation/transformationWidgetService');

    var TransformationComponent = function (params) {
        var self = this;
        self.widget = params.widget;
        self.$element = $(params.element);
        self.pages = [];

        var parentSettings = self.widget.settings;
        var widgetSettings = self.widget.settings.data;

        var minute = 1000 * 60;
        var loadWidget = function() {
            transformationWidgetService.loadData(parentSettings, widgetSettings)
                .timeout(minute * 12)
                .then(function (transformationData) {
                    return transformationWidgetService.loadTransformation(transformationData, self.$element);
                })
                .then(function (pages) {
                    self.pages = pages;
                })
            .finally(function () {
                self.widget.setLoaded();
            });
        };

        self.widget.onplay = function () {
            transformationWidgetService.play(self.pages, parentSettings)
                .timeout(minute * 45)
                .finally(function () {
                    self.widget.setPlayed();
                });
        };

        self.widget.sendInitialized();
        loadWidget();
    };

    return TransformationComponent;
});
