define(['knockout', 'bluebird', 'jquery', 'videojs-youtube', 'tnc/tnc-tools'],
function () {
    'use strict';

    var ko = require("knockout");
    var Promise = require('bluebird');
    var $ = require('jquery');
    var tncTools = require('tnc/tnc-tools');
    var videojs = window.videojs;

    var YoutubeComponent = function (params) {
        var self = this;
        self.widget = params.widget;
        self.$element = $(params.element);

        self.sources = ko.observableArray([]);

        $('head').append('<link href="theme/video/video-js.min.css" rel="stylesheet"/>');
        var loadWidget = function() {

            if (self.widget.settings.template.novideo) {
                self.widget.setLoaded();
                $('.disabled-video-icon').css({ visibility: 'visible' });
                return;
            }

            var notPlayingTimeout = setTimeout(function () {
                var isPlaying = (self.player && self.player.currentTime() > 0);
                if (!isPlaying)
                {
                    self.widget.setPlayed();
                }
            }, 7000);

            var videoUrl = 'https://www.youtube.com/watch?v=' + self.widget.settings.data.videoID;
            // https://www.youtube.com/watch?v=xjS6SftYQaQ
            var sources = [{
                src: videoUrl,
                type: 'video/youtube'
            }];

            var videojsSettings = {
                sources: sources,
                techOrder: ['youtube'],
            };
            videojs('video-player1', videojsSettings).ready(function() {
                self.player = this;


                self.player.on('error', function(err){
                    self.widget.setPlayed();
                });

                self.player.on('loadeddata', function() {
                    clearTimeout(notPlayingTimeout);
                });

                setTimeout(function() {
                    self.widget.setLoaded();
                }, 500);
            });
        };
        loadWidget();

        self.widget.onplay = function() {
            if (self.player)
            {
                if (self.widget.settings && self.widget.settings.duration >= 1)
                {
                    setTimeout(function() {
                        self.widget.setPlayed();
                    }, self.widget.settings.duration)
                }

                self.player.on('ended', function() {
                    $('.video-container').css({ display: 'none' });
                    self.widget.setPlayed();
                  });
                self.player.play();
            }
            else
            {
                var duration = 10000;
                if (self.widget.settings && self.widget.settings.duration >= 1)
                {
                    duration = self.widget.settings.duration;
                }
                setTimeout(function() {
                    self.widget.setPlayed();
                }, duration);
            }
        };

        self.widget.sendInitialized();
    };
    return YoutubeComponent;
});
